/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.view.components;

import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

class FileListTableModel
extends AbstractTableModel {
    private List<DataFile> rows;
    private String[] columnNames = new String[]{Res.getString("Table_Name"), Res.getString("Table_Path"), Res.getString("Table_Comment")};

    public FileListTableModel() {
        this.rows = new Vector<DataFile>(10, 10);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        DataFile rowDataFile = this.rows.get(row);
        switch (column) {
            case 0: {
                return rowDataFile.getFile().getName();
            }
            case 1: {
                try {
                    return rowDataFile.getFile().getParentFile().getCanonicalPath();
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                if (rowDataFile.hasComment()) {
                    return new JLabel(Res.getImageIcon("note12.gif"));
                }
                return new JLabel("");
            }
        }
        return null;
    }

    public DataFile getDataFileForRow(int row) {
        return this.rows.get(row);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public List<DataFile> getRows() {
        return this.rows;
    }

    public void addDataFile(DataFile dataFile) {
        this.rows.add(dataFile);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void removeDataFile(DataFile dataFile) {
        this.rows.remove(dataFile);
        this.fireTableRowsDeleted(0, 0);
    }
}

