/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.view.components;

import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.model.DataFileEvent;
import belfius.gegn.tool.filetransfer.hash.model.DataFileListener;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import belfius.gegn.tool.filetransfer.hash.view.components.FileListTableCommentCellRenderer;
import belfius.gegn.tool.filetransfer.hash.view.components.FileListTableHeaderRenderer;
import belfius.gegn.tool.filetransfer.hash.view.components.FileListTableModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JTable;

public class FileListTable
extends JTable
implements MouseListener,
DataFileListener {
    private Point pointPressed;

    public FileListTable() {
        super(new FileListTableModel());
        this.addMouseListener(this);
        this.getTableHeader().setDefaultRenderer(new FileListTableHeaderRenderer());
        this.getColumnModel().getColumn(0).setHeaderValue(new JLabel(this.getModel().getColumnName(0)));
        this.getColumnModel().getColumn(1).setHeaderValue(new JLabel(this.getModel().getColumnName(1)));
        this.getColumnModel().getColumn(2).setHeaderValue(new JLabel(Res.getImageIcon("note12.gif")));
        ((JLabel)this.getColumnModel().getColumn(2).getHeaderValue()).setToolTipText(this.getModel().getColumnName(2));
        this.getColumnModel().getColumn(2).setCellRenderer(new FileListTableCommentCellRenderer());
        this.setAutoResizeMode(1);
        this.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.getColumnModel().getColumn(2).setMinWidth(20);
        this.getColumnModel().getColumn(2).setMaxWidth(20);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().revalidate();
        this.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.setFillsViewportHeight(true);
    }

    public void addDataFile(DataFile dataFile) {
        ((FileListTableModel)this.getModel()).addDataFile(dataFile);
        this.repaint();
    }

    public void removeDataFile(DataFile dataFile) {
        ((FileListTableModel)this.getModel()).removeDataFile(dataFile);
        this.repaint();
    }

    private Point getPointPressed() {
        return this.pointPressed;
    }

    private void setPointPressed(Point pointPressed) {
        this.pointPressed = pointPressed;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.setPointPressed(event.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.rowAtPoint(this.getPointPressed()) == -1 && this.rowAtPoint(event.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    public int[] getSelectedRowIDs() {
        int[] selectedRow = this.getSelectedRows();
        int[] result = new int[selectedRow.length];
        int i = 0;
        while (i < selectedRow.length) {
            DataFile aRow = ((FileListTableModel)this.getModel()).getDataFileForRow(selectedRow[i]);
            result[i] = aRow.getId();
            ++i;
        }
        return result;
    }

    @Override
    public void dataFilePropertyChanged(DataFileEvent event) {
        this.repaint();
    }

    @Override
    public void dataFileRemoved(DataFileEvent event) {
    }

    @Override
    public void dataFileAdded(DataFileEvent event) {
    }
}

