/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.view.components;

import belfius.gegn.tool.filetransfer.hash.controller.DataFileController;
import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import belfius.gegn.tool.filetransfer.hash.util.SpringUtilities;
import belfius.gegn.tool.filetransfer.hash.view.components.FileListTable;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileDetailPanel
implements ListSelectionListener,
ActionListener {
    private DataFileController controller;
    private FileListTable fileListTable;
    private JPanel panel = null;
    private JTextField fileDetailsFileText;
    private JTextField fileDetailsHashText;
    private JTextArea fileDetailsCommentText;
    private JButton fileCommentSave;

    public FileDetailPanel(DataFileController controller, FileListTable fileListTable) {
        this.controller = controller;
        this.fileListTable = fileListTable;
    }

    public JPanel createPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        JPanel fileDetailsPanel = new JPanel(new SpringLayout());
        fileDetailsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(Res.getString("Label_FileDetails"))));
        JLabel fileDetailsFileLabel = new JLabel(Res.getString("Label_File"), 11);
        fileDetailsPanel.add(fileDetailsFileLabel);
        this.fileDetailsFileText = new JTextField();
        this.fileDetailsFileText.setEditable(false);
        fileDetailsPanel.add(this.fileDetailsFileText);
        JLabel fileDetailsHashLabel = new JLabel(Res.getString("Label_Hash"), 11);
        fileDetailsPanel.add(fileDetailsHashLabel);
        this.fileDetailsHashText = new JTextField();
        this.fileDetailsHashText.setEditable(false);
        fileDetailsPanel.add(this.fileDetailsHashText);
        JLabel fileDetailsCommentLabel = new JLabel(Res.getString("Label_Comment"), 11);
        fileDetailsPanel.add(fileDetailsCommentLabel);
        this.fileDetailsCommentText = new JTextArea();
        this.fileDetailsCommentText.setLineWrap(true);
        this.fileDetailsCommentText.setWrapStyleWord(true);
        JScrollPane fileDetailsCommentTextPane = new JScrollPane(this.fileDetailsCommentText, 20, 31);
        fileDetailsCommentTextPane.setPreferredSize(new Dimension(300, 51));
        this.fileDetailsCommentText.setEditable(false);
        fileDetailsPanel.add(fileDetailsCommentTextPane);
        JLabel fileDetailsCommentLabela = new JLabel("", 11);
        fileDetailsPanel.add(fileDetailsCommentLabela);
        this.fileCommentSave = new JButton(Res.getString("Label_SaveComment"));
        this.fileCommentSave.setEnabled(false);
        fileDetailsPanel.add(this.fileCommentSave);
        this.fileCommentSave.addActionListener(this);
        SpringUtilities.makeCompactGrid(fileDetailsPanel, 4, 2, 5, 5, 3, 3);
        return fileDetailsPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selectedRows = this.fileListTable.getSelectedRowIDs();
        if (selectedRows.length == 1) {
            DataFile temp = this.controller.getModel().getDataFile(selectedRows[0]);
            this.fileDetailsFileText.setText(temp.getFile().toString());
            this.fileDetailsHashText.setText(temp.getHexedHashCode());
            this.fileDetailsCommentText.setText(temp.getComment());
            this.fileDetailsCommentText.setEditable(true);
            this.fileCommentSave.setEnabled(true);
        } else if (selectedRows.length > 1) {
            this.fileDetailsFileText.setText("MULTI");
            this.fileDetailsHashText.setText("MULTI");
            this.fileDetailsCommentText.setText("");
            this.fileDetailsCommentText.setEditable(true);
            this.fileCommentSave.setEnabled(true);
        } else {
            this.fileDetailsFileText.setText("");
            this.fileDetailsHashText.setText("");
            this.fileDetailsCommentText.setText("");
            this.fileDetailsCommentText.setEditable(false);
            this.fileCommentSave.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.controller.changeComment(this.fileListTable.getSelectedRowIDs(), this.fileDetailsCommentText.getText());
    }
}

