/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.view;

import belfius.gegn.tool.filetransfer.hash.res.Res;
import belfius.gegn.tool.filetransfer.hash.util.Sha1Prerferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PreferencesWindow
extends JDialog {
    private static final long serialVersionUID = -8741183073018992511L;
    private JTextField importPathText;
    private JTextField exportPathText;
    private JComboBox languageComboBox;
    private Sha1Prerferences preferences;

    public PreferencesWindow(Sha1Prerferences preferences, JFrame parentWindow) {
        super((Frame)parentWindow, Res.getString("Title_Preferences"));
        this.setModal(true);
        this.setSize(300, 200);
        Point point = parentWindow.getLocationOnScreen();
        this.setLocation(point.x + 30, point.y + 30);
        this.setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.preferences = preferences;
        this.initComponentsGrid();
        this.setVisible(true);
    }

    private void initComponentsGrid() {
        JLabel importPathLabel = new JLabel(Res.getString("Label_ImportPath"), 11);
        this.add((Component)importPathLabel, this.getLabelConstraints(0, 0));
        this.importPathText = new JTextField();
        this.importPathText.setEnabled(false);
        this.importPathText.setDisabledTextColor(Color.gray);
        this.importPathText.setText(this.preferences.getImportPath());
        this.add((Component)this.importPathText, this.getTextFieldConstraints(1, 0));
        ImportButton importPathButton = new ImportButton();
        this.add((Component)importPathButton, this.getPathButtonConstraints(2, 0));
        JLabel exportPathLabel = new JLabel(Res.getString("Label_ExportPath"), 11);
        this.add((Component)exportPathLabel, this.getLabelConstraints(0, 1));
        this.exportPathText = new JTextField();
        this.exportPathText.setEnabled(false);
        this.exportPathText.setDisabledTextColor(Color.gray);
        this.exportPathText.setText(this.preferences.getExportPath());
        this.add((Component)this.exportPathText, this.getTextFieldConstraints(1, 1));
        ExportButton exportPathButton = new ExportButton();
        this.add((Component)exportPathButton, this.getPathButtonConstraints(2, 1));
        JLabel languageLabel = new JLabel(Res.getString("Label_Language"), 11);
        this.add((Component)languageLabel, this.getLabelConstraints(0, 2));
        Vector<KeyValue> labels = new Vector<KeyValue>();
        labels.add(new KeyValue(Res.getString("Language_Dutch"), "nl"));
        labels.add(new KeyValue(Res.getString("Language_French"), "fr"));
        labels.add(new KeyValue(Res.getString("Language_English"), "en"));
        labels.add(new KeyValue(Res.getString("Language_German"), "de"));
        this.languageComboBox = new JComboBox(labels);
        this.languageComboBox.setMaximumRowCount(4);
        this.languageComboBox.setRenderer(new LanguageListCellRenderer());
        this.languageComboBox.addActionListener(new LanguageListener());
        String lang = this.preferences.getLanguage();
        if (lang.equals("nl")) {
            this.languageComboBox.setSelectedIndex(0);
        } else if (lang.equals("fr")) {
            this.languageComboBox.setSelectedIndex(1);
        } else if (lang.equals("de")) {
            this.languageComboBox.setSelectedIndex(3);
        } else {
            this.languageComboBox.setSelectedIndex(2);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        this.add((Component)this.languageComboBox, c);
        CloseButton close = new CloseButton();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.insets = new Insets(2, 2, 2, 2);
        this.add((Component)close, c);
        this.addWindowListener(close);
    }

    private GridBagConstraints getLabelConstraints(int x, int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = x;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 13;
        return c;
    }

    private GridBagConstraints getTextFieldConstraints(int x, int y) {
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        return c;
    }

    private GridBagConstraints getPathButtonConstraints(int x, int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.fill = 1;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        return c;
    }

    public File selectPath(File directory) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setCurrentDirectory(directory);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showDialog(this, Res.getString("ChooseDirectory")) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public class CloseButton
    extends JButton
    implements ActionListener,
    WindowListener {
        public CloseButton() {
            super(Res.getString("Button_Close"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.setVisible(false);
            PreferencesWindow.this.dispose();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.setVisible(false);
            PreferencesWindow.this.dispose();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    public class ExportButton
    extends JButton
    implements ActionListener {
        public ExportButton() {
            super("...");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            File newPath = PreferencesWindow.this.selectPath(new File(PreferencesWindow.this.exportPathText.getText()));
            if (newPath != null) {
                PreferencesWindow.this.preferences.setExportPath(newPath.getPath());
                PreferencesWindow.this.exportPathText.setText(newPath.getPath());
            }
        }
    }

    public class ImportButton
    extends JButton
    implements ActionListener {
        public ImportButton() {
            super("...");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            File newPath = PreferencesWindow.this.selectPath(new File(PreferencesWindow.this.importPathText.getText()));
            if (newPath != null) {
                PreferencesWindow.this.preferences.setImportPath(newPath.getPath());
                PreferencesWindow.this.importPathText.setText(newPath.getPath());
            }
        }
    }

    public class KeyValue {
        String key;
        String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class LanguageListCellRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = new JLabel();
            renderer.setText(" " + ((KeyValue)value).getKey());
            renderer.setBackground(isSelected ? list.getBackground() : Color.white);
            renderer.setOpaque(true);
            return renderer;
        }
    }

    public class LanguageListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            JComboBox combo = (JComboBox)arg0.getSource();
            KeyValue test = (KeyValue)combo.getSelectedItem();
            PreferencesWindow.this.preferences.setLanguage(test.getValue());
        }
    }
}

