/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.view;

import belfius.gegn.tool.filetransfer.hash.controller.DataFileController;
import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.model.DataFileEvent;
import belfius.gegn.tool.filetransfer.hash.model.DataFileModel;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import belfius.gegn.tool.filetransfer.hash.services.ExporterException;
import belfius.gegn.tool.filetransfer.hash.util.Sha1Prerferences;
import belfius.gegn.tool.filetransfer.hash.view.DataFileView;
import belfius.gegn.tool.filetransfer.hash.view.MainWindowAction;
import belfius.gegn.tool.filetransfer.hash.view.PreferencesWindow;
import belfius.gegn.tool.filetransfer.hash.view.components.FileDetailPanel;
import belfius.gegn.tool.filetransfer.hash.view.components.FileListTable;
import belfius.gegn.tool.filetransfer.hash.view.components.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public class MainWindow
extends JFrame
implements DataFileView {
    private DataFileController controller;
    private FileListTable fileListTable;
    private MainWindowAction actionRemoveFiles;
    private MainWindowAction actionExportFiles;
    private Sha1Prerferences preferences = new Sha1Prerferences();

    public MainWindow(DataFileController controller) {
        this.controller = controller;
        this.initComponents();
        this.setVisible(true);
    }

    public File[] openFiles(File directory) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showDialog(this, Res.getString("Menu_EditAddFiles")) == 0) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    private void initComponents() {
        this.setLocaleInfo(this.preferences.getLanguage());
        MainWindowAction actionAddFiles = new MainWindowAction(Res.getString("Menu_EditAddFiles"), Res.getImageIcon("add16.gif"), this){

            @Override
            public void actionPerformed(ActionEvent event) {
                File importPath = new File(MainWindow.this.preferences.getSessionImportPath());
                File[] files = this.getMainWindow().openFiles(importPath);
                if (files != null) {
                    File temp = files[files.length - 1];
                    MainWindow.this.preferences.setSessionImportPath(temp.getParent());
                    MainWindow.this.controller.addFiles(files);
                }
            }
        };
        actionAddFiles.putValue("ShortDescription", Res.getString("Button_AddFiles"));
        actionAddFiles.putValue("ActionCommandKey", "addFiles");
        this.actionRemoveFiles = new MainWindowAction(Res.getString("Menu_EditRemoveFiles"), Res.getImageIcon("remove16.gif"), this){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.controller.removeFiles(MainWindow.this.fileListTable.getSelectedRowIDs());
            }

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    this.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
                }
            }
        };
        this.actionRemoveFiles.putValue("ShortDescription", Res.getString("Button_RemoveFiles"));
        this.actionRemoveFiles.putValue("ActionCommandKey", "removeFiles");
        this.actionRemoveFiles.setEnabled(false);
        this.actionExportFiles = new MainWindowAction(Res.getString("Menu_EditExportFiles"), Res.getImageIcon("export16.gif"), this){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (MainWindow.this.fileListTable.getSelectedRowCount() > 0) {
                        String exportFileName = MainWindow.this.controller.exportFiles(MainWindow.this.fileListTable.getSelectedRowIDs());
                        if (exportFileName != null) {
                            JOptionPane.showMessageDialog(null, String.valueOf(Res.getString("PopText_FileExported")) + " " + exportFileName, Res.getString("PopTextTitle_ExportedOk"), -1);
                        } else {
                            JOptionPane.showMessageDialog(null, Res.getString("PopText_ExportCancelledByUser"), Res.getString("PopTextTitle_ExportProblem"), 2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, Res.getString("PopText_NoFilesSelected"), Res.getString("PopTextTitle_ExportProblem"), 0);
                    }
                }
                catch (ExporterException e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(Res.getString("PopText_UnknownError")) + "\n" + e.getMessage() + "\n" + e.getStackTrace(), Res.getString("PopTextTitle_ExportProblem"), 0);
                }
            }

            @Override
            public void tableChanged(TableModelEvent event) {
                this.setEnabled(MainWindow.this.fileListTable.getRowCount() != 0);
            }

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    this.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
                }
            }
        };
        this.actionExportFiles.putValue("ShortDescription", "short");
        this.actionExportFiles.putValue("ActionCommandKey", "commandKeyOpenFolder");
        this.actionExportFiles.setEnabled(false);
        MainWindowAction actionOpenExportFolder = new MainWindowAction(Res.getString("Button_OpenExportDirectory"), Res.getImageIcon("opened_folder.gif"), this){

            @Override
            public void actionPerformed(ActionEvent event) {
                File exportPath = new File(MainWindow.this.preferences.getExportPath());
                String paramStringForExporer = exportPath.toString();
                try {
                    Process process = new ProcessBuilder("explorer.exe", paramStringForExporer).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        actionOpenExportFolder.putValue("ShortDescription", Res.getString("Button_OpenExportDirectory"));
        actionOpenExportFolder.setEnabled(true);
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu(Res.getString("Menu_File"));
        JMenuItem menuFileRestart = new JMenuItem(Res.getString("Menu_FileRestart"));
        menuFileRestart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setVisible(false);
                MainWindow.this.dispose();
                DataFileController controller = new DataFileController(new DataFileModel());
                controller.addView(new MainWindow(controller));
            }
        });
        menuFile.add(menuFileRestart);
        menuFile.addSeparator();
        JMenuItem menuFileExit = new JMenuItem(Res.getString("Menu_FileExit"));
        menuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setVisible(false);
                MainWindow.this.dispose();
                System.exit(0);
            }
        });
        menuFile.add(menuFileExit);
        menuBar.add(menuFile);
        JMenu menuEdit = new JMenu(Res.getString("Menu_Edit"));
        JMenuItem menuEditAdd = new JMenuItem(actionAddFiles);
        menuEditAdd.setIcon(null);
        menuEdit.add(menuEditAdd);
        JMenuItem menuEditRemove = new JMenuItem(this.actionRemoveFiles);
        menuEditRemove.setIcon(null);
        menuEdit.add(menuEditRemove);
        JMenuItem menuEditExport = new JMenuItem(this.actionExportFiles);
        menuEditExport.setIcon(null);
        menuEdit.add(menuEditExport);
        menuEdit.addSeparator();
        menuEdit.add(new MainWindowAction(Res.getString("Menu_EditSelectionAll"), null, this){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.fileListTable.selectAll();
            }
        });
        menuBar.add(menuEdit);
        JMenu menuWindow = new JMenu(Res.getString("Menu_Window"));
        menuWindow.add(new MainWindowAction(Res.getString("Menu_WindowPreferences"), null, this){

            @Override
            public void actionPerformed(ActionEvent event) {
                new PreferencesWindow(MainWindow.this.preferences, this.getMainWindow());
            }
        });
        JMenuItem menuOpenExportFolder = new JMenuItem(actionOpenExportFolder);
        menuOpenExportFolder.setIcon(null);
        menuWindow.add(menuOpenExportFolder);
        menuBar.add(menuWindow);
        StatusBar statusBar = new StatusBar(true);
        JPanel fileListPanel = new JPanel(new BorderLayout());
        fileListPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Res.getString("Label_FileList")), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        JToolBar fileListToolBar = new JToolBar();
        JButton fileListToolBarAdd = new JButton(actionAddFiles);
        fileListToolBarAdd.setOpaque(false);
        fileListToolBarAdd.setFocusable(false);
        fileListToolBar.add(fileListToolBarAdd);
        JButton fileListToolBarRemove = new JButton(this.actionRemoveFiles);
        fileListToolBarRemove.setOpaque(false);
        fileListToolBarRemove.setFocusable(false);
        fileListToolBar.add(fileListToolBarRemove);
        fileListToolBar.add(Box.createRigidArea(new Dimension(40, fileListToolBar.getPreferredSize().height)));
        fileListToolBar.add(Box.createHorizontalGlue());
        JButton fileListToolBarOpenExportFolderButton = new JButton(actionOpenExportFolder);
        fileListToolBar.add(fileListToolBarOpenExportFolderButton);
        fileListToolBarOpenExportFolderButton.setFocusable(false);
        fileListToolBarOpenExportFolderButton.setOpaque(false);
        JButton fileListToolBarExport = new JButton(this.actionExportFiles);
        fileListToolBarExport.setOpaque(false);
        fileListToolBarExport.setFocusable(false);
        fileListToolBar.add(fileListToolBarExport);
        fileListToolBar.setRollover(true);
        fileListToolBar.setFloatable(false);
        fileListToolBar.setBorderPainted(true);
        fileListToolBar.setBorder(BorderFactory.createEmptyBorder());
        fileListPanel.add((Component)fileListToolBar, "First");
        this.fileListTable = new FileListTable();
        this.fileListTable.getSelectionModel().addListSelectionListener(this.actionRemoveFiles);
        this.fileListTable.getSelectionModel().addListSelectionListener(this.actionExportFiles);
        this.fileListTable.getModel().addTableModelListener(this.actionExportFiles);
        this.controller.getModel().addDataFileListener(this.fileListTable);
        JScrollPane fileListTablePane = new JScrollPane(this.fileListTable, 20, 31);
        fileListPanel.add((Component)fileListTablePane, "Center");
        FileDetailPanel fileDetailPanel = new FileDetailPanel(this.controller, this.fileListTable);
        this.fileListTable.getSelectionModel().addListSelectionListener(fileDetailPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)fileListPanel, "Center");
        mainPanel.add((Component)fileDetailPanel.createPanel(), "Last");
        this.setTitle(Res.getString("Title_MainWindow"));
        this.setDefaultCloseOperation(0);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(menuBar);
        this.getContentPane().add((Component)statusBar, "Last");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setLocationByPlatform(true);
        this.pack();
    }

    private void setLocaleInfo(String prefLanguage) {
        Res.setLocale(prefLanguage);
        Locale loc = prefLanguage.equalsIgnoreCase("nl") ? Locale.ENGLISH : (prefLanguage.equalsIgnoreCase("fr") ? Locale.FRENCH : (prefLanguage.equalsIgnoreCase("de") ? Locale.GERMAN : Locale.ENGLISH));
        JComponent.setDefaultLocale(loc);
        Locale.setDefault(loc);
    }

    @Override
    public void dataFileAdded(DataFileEvent event) {
        this.fileListTable.addDataFile((DataFile)event.getSource());
    }

    @Override
    public void dataFilePropertyChanged(DataFileEvent event) {
        DataFile test = (DataFile)event.getSource();
    }

    @Override
    public void dataFileRemoved(DataFileEvent event) {
        this.fileListTable.removeDataFile((DataFile)event.getSource());
    }
}

