/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.util;

import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class TextToPDF {
    private int fontSize = 10;
    private PDSimpleFont font = PDType1Font.HELVETICA;

    public PDDocument createPDFFromText(List<DataFile> dataFiles) throws IOException {
        PDDocument doc = null;
        try {
            int margin = 40;
            float height = this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
            height = height * (float)this.fontSize * 1.05f;
            doc = new PDDocument();
            PDJpeg ximage = null;
            BufferedImage printLogo = ImageIO.read(Res.getJPGImage("printLogo.jpg"));
            ximage = new PDJpeg(doc, printLogo);
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            int pageNumber = 1;
            Date datum = new Date(System.currentTimeMillis());
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            boolean newPageIsNeeded = false;
            PDPage page = new PDPage();
            doc.addPage(page);
            contentStream = new PDPageContentStream(doc, page);
            y = page.getMediaBox().getHeight() - 40.0f + height;
            float middleX = page.getMediaBox().getWidth() / 2.0f;
            contentStream.drawImage((PDXObjectImage)ximage, 10.0f, y -= 50.0f);
            contentStream.beginText();
            contentStream.moveTextPositionByAmount(100.0f, y);
            contentStream.setFont((PDFont)this.font, 16.0f);
            contentStream.moveTextPositionByAmount(0.0f, -height);
            contentStream.drawString("BelfiusWeb HashCalculation (" + formatter.format(datum) + ")");
            contentStream.endText();
            contentStream.beginText();
            contentStream.moveTextPositionByAmount(40.0f, y - 40.0f);
            for (DataFile dataFile : dataFiles) {
                if (newPageIsNeeded) {
                    contentStream.endText();
                    contentStream.beginText();
                    contentStream.moveTextPositionByAmount(middleX - 5.0f, 40.0f);
                    contentStream.setFont((PDFont)this.font, (float)this.fontSize);
                    contentStream.drawString("- " + pageNumber + " -");
                    newPageIsNeeded = false;
                    contentStream.endText();
                    contentStream.close();
                    ++pageNumber;
                    page = new PDPage();
                    doc.addPage(page);
                    contentStream = new PDPageContentStream(doc, page);
                    y = page.getMediaBox().getHeight() - 40.0f + height;
                    contentStream.beginText();
                    contentStream.moveTextPositionByAmount(40.0f, y);
                }
                contentStream.setFont((PDFont)this.font, (float)this.fontSize);
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                contentStream.drawString(String.valueOf(Res.getString("PDF_Filename")) + " :\t" + dataFile.getFile().getName());
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                contentStream.drawString(String.valueOf(Res.getString("PDF_Path")) + " :\t" + dataFile.getFile().getParent());
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                contentStream.drawString(String.valueOf(Res.getString("PDF_Hash")) + " :\t" + dataFile.getHexedHashCode() + "\t");
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                contentStream.setNonStrokingColor(Color.RED);
                contentStream.drawString(String.valueOf(Res.getString("PDF_BelfiusWebDigits")) + " :\t" + dataFile.getFirstDigitsOfHexedHashCode() + "\t");
                contentStream.setNonStrokingColor(Color.BLACK);
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                int endIndex = 50;
                if (dataFile.getComment().length() > endIndex) {
                    contentStream.drawString(String.valueOf(Res.getString("PDF_Description")) + " :\t" + dataFile.getComment().substring(0, 50));
                    int beginIndex = 50;
                    endIndex = dataFile.getComment().length() < beginIndex + 50 ? dataFile.getComment().length() : beginIndex + 50;
                    while (endIndex <= dataFile.getComment().length() && beginIndex < endIndex) {
                        contentStream.moveTextPositionByAmount(0.0f, -height);
                        y -= height;
                        contentStream.drawString("\t" + dataFile.getComment().substring(beginIndex, endIndex));
                        endIndex = dataFile.getComment().length() < (beginIndex += endIndex) + 50 ? dataFile.getComment().length() : beginIndex + 50;
                        System.out.println("beginIndex=" + beginIndex + " endIndex=" + endIndex + " TOTAL" + dataFile.getComment().length());
                    }
                } else {
                    contentStream.drawString(String.valueOf(Res.getString("PDF_Description")) + " :\t" + dataFile.getComment().substring(0, dataFile.getComment().length()));
                }
                contentStream.moveTextPositionByAmount(0.0f, -height);
                y -= height;
                if (!(y < 140.0f)) continue;
                newPageIsNeeded = true;
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(middleX - 5.0f, 40.0f);
                contentStream.setFont((PDFont)this.font, (float)this.fontSize);
                contentStream.drawString("- " + pageNumber + " -");
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
        return doc;
    }

    public PDSimpleFont getFont() {
        return this.font;
    }

    public void setFont(PDSimpleFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }
}

