/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.services.impl;

import belfius.gegn.tool.filetransfer.hash.services.Calculator;
import belfius.gegn.tool.filetransfer.hash.services.CalculatorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1Calculator
implements Calculator {
    private ByteBuffer buffer = ByteBuffer.allocate(32768);
    private MessageDigest digest;

    public SHA1Calculator() throws CalculatorException {
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CalculatorException(1, "Algorithm SHA-1 unknown, could not initialize calculator", e);
        }
    }

    @Override
    public synchronized byte[] calculate(File file) throws FileNotFoundException, CalculatorException {
        byte[] hash = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel channel = fileInputStream.getChannel();
        try {
            try {
                while (channel.read(this.buffer) != -1) {
                    this.buffer.flip();
                    this.digest.update(this.buffer);
                    this.buffer.clear();
                }
                hash = this.digest.digest();
            }
            catch (IOException e) {
                throw new CalculatorException(2, "An error occurred in the SHA-1 calculation of file " + file.getName(), e);
            }
        }
        finally {
            try {
                channel.close();
                fileInputStream.close();
            }
            catch (IOException e) {
                throw new CalculatorException(3, "An error occurred while closing down file " + file.getName(), e);
            }
            this.buffer.clear();
            this.digest.reset();
        }
        return hash;
    }
}

