/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.services.impl;

import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.res.Res;
import belfius.gegn.tool.filetransfer.hash.services.Exporter;
import belfius.gegn.tool.filetransfer.hash.services.ExporterException;
import belfius.gegn.tool.filetransfer.hash.util.Sha1Prerferences;
import belfius.gegn.tool.filetransfer.hash.util.TextToPDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

public class PDFExporter
implements Exporter {
    @Override
    public String export(DataFile dataFile) throws ExporterException {
        Vector<DataFile> dataFiles = new Vector<DataFile>(1);
        dataFiles.add(dataFile);
        return this.export(dataFiles);
    }

    @Override
    public String export(List<DataFile> dataFiles) throws ExporterException {
        TextToPDF tool = new TextToPDF();
        try {
            PDDocument pdf = tool.createPDFFromText(dataFiles);
            GregorianCalendar cal = new GregorianCalendar();
            Date datum = new Date(System.currentTimeMillis());
            SimpleDateFormat temp = new SimpleDateFormat("dd-MM-yyyy--HH-mm-ss");
            temp.format(datum);
            PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
            HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
            for (DataFile dataFile : dataFiles) {
                PDComplexFileSpecification fs = new PDComplexFileSpecification();
                fs.setFile(dataFile.getFile().getName());
                FileInputStream is = new FileInputStream(dataFile.getFile());
                PDEmbeddedFile ef = new PDEmbeddedFile(pdf, (InputStream)is);
                ef.setSubtype("text/plain");
                ef.setSize((int)dataFile.getFile().length());
                ef.setCreationDate((Calendar)new GregorianCalendar());
                fs.setEmbeddedFile(ef);
                efMap.put(dataFile.getFile().getName(), fs);
            }
            efTree.setNames(efMap);
            ((COSDictionary)efTree.getCOSObject()).removeItem(COSName.LIMITS);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(pdf.getDocumentCatalog());
            names.setEmbeddedFiles(efTree);
            pdf.getDocumentCatalog().setNames(names);
            Sha1Prerferences pref = new Sha1Prerferences();
            String pathToWriteTo = pref.getExportPath();
            String proposedFileToSave = String.valueOf(pathToWriteTo) + "/" + temp.format(datum) + "_BelfiusWebHash.pdf";
            File fileToSave = this.chooseSaveFileName(new File(proposedFileToSave));
            if (fileToSave != null) {
                pdf.save(fileToSave.getAbsolutePath());
                pdf.close();
                return fileToSave.getAbsolutePath();
            }
            pdf.close();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExporterException("IO ERROR", e);
        }
        catch (COSVisitorException e) {
            e.printStackTrace();
            throw new ExporterException("PDF ERROR", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExporterException("UNKNOWN", e);
        }
    }

    public File chooseSaveFileName(File file) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setCurrentDirectory(file.getParentFile());
        fileChooser.setSelectedFile(file);
        if (fileChooser.showDialog(null, Res.getString("Label_ExportPath")) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

