/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.model;

import belfius.gegn.tool.filetransfer.hash.model.AbstractDataFileModel;
import belfius.gegn.tool.filetransfer.hash.model.DataFile;
import belfius.gegn.tool.filetransfer.hash.model.DataFileEvent;
import belfius.gegn.tool.filetransfer.hash.services.Calculator;
import belfius.gegn.tool.filetransfer.hash.services.CalculatorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataFileModel
extends AbstractDataFileModel {
    private Set<DataFile> dataFiles = Collections.synchronizedSet(new HashSet());

    public void addFiles(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addFile(file);
            ++n2;
        }
    }

    public void addFiles(File[] files, Calculator calculator) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addFile(file, calculator);
            ++n2;
        }
    }

    public void addFile(File file) {
        DataFile dataFile = new DataFile(file);
        if (this.dataFiles.add(dataFile)) {
            this.fireEvent(new DataFileEvent(dataFile, 3));
        }
    }

    public void addFile(File file, Calculator calculator) {
        try {
            DataFile dataFile = new DataFile(file);
            dataFile.setHash(calculator.calculate(file));
            if (this.dataFiles.add(dataFile)) {
                this.fireEvent(new DataFileEvent(dataFile, 3));
            }
        }
        catch (CalculatorException calculatorException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void removeFiles(int[] ids) {
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.removeFile(id);
            ++n2;
        }
    }

    public void removeFile(int id) {
        DataFile dataFile = this.getDataFile(id);
        if (this.dataFiles.remove(dataFile)) {
            this.fireEvent(new DataFileEvent(dataFile, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFile getDataFile(int id) {
        Set<DataFile> set = this.dataFiles;
        synchronized (set) {
            for (DataFile dataFile : this.dataFiles) {
                if (dataFile.getId() != id) continue;
                return dataFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataFile> getDataFiles(int[] ids) {
        ArrayList<DataFile> dataFileList = new ArrayList<DataFile>();
        Set<DataFile> set = this.dataFiles;
        synchronized (set) {
            for (DataFile dataFile : this.dataFiles) {
                int[] nArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (dataFile.getId() == id) {
                        dataFileList.add(dataFile);
                    }
                    ++n2;
                }
            }
        }
        return dataFileList;
    }

    public void changeComment(int[] ids, String comment) {
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.changeComment(id, comment);
            ++n2;
        }
    }

    public void changeComment(int id, String comment) {
        DataFile dataFile = this.getDataFile(id);
        String oldComment = dataFile.getComment();
        dataFile.setComment(comment);
        this.fireEvent(new DataFileEvent(dataFile, 1, DataFile.PROPERTY_COMMENT, oldComment, comment));
    }
}

