/*
 * Decompiled with CFR 0.152.
 */
package belfius.gegn.tool.filetransfer.hash.model;

import belfius.gegn.tool.filetransfer.hash.util.Util;
import java.io.File;

public class DataFile {
    private File file;
    private int id;
    private byte[] hash;
    private String comment;
    private static int idCounter = 0;
    public static String PROPERTY_FILE = "file";
    public static String PROPERTY_ID = "id";
    public static String PROPERTY_HASH = "hash";
    public static String PROPERTY_COMMENT = "comment";

    public boolean equals(Object object) {
        try {
            return this.getFile().equals(((DataFile)object).getFile());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public String getHexedHashCode() {
        return Util.byteArrayToHexString(this.getHash());
    }

    public String getFirstDigitsOfHexedHashCode() {
        String hexedHash = this.getHexedHashCode();
        StringBuffer firstDigits = new StringBuffer();
        int i = 0;
        while (i < hexedHash.length() && firstDigits.length() < 10) {
            char unknownCharacter = hexedHash.charAt(i);
            if (Character.isDigit(unknownCharacter)) {
                firstDigits.append(unknownCharacter);
            }
            ++i;
        }
        return firstDigits.toString();
    }

    public DataFile(File file) {
        this.file = file;
        this.id = idCounter++;
        this.comment = "";
    }

    public final int getId() {
        return this.id;
    }

    public final File getFile() {
        return this.file;
    }

    public final byte[] getHash() {
        return this.hash;
    }

    public final void setHash(byte[] hash) {
        this.hash = hash;
    }

    public final boolean hasComment() {
        return !this.comment.isEmpty();
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        this.comment = comment == null ? "" : comment.trim();
    }
}

